#!/usr/bin/perl -w
#
# 
# Copyright (C) 2003 Alexandre Dulaunoy <adulau@foo.be>
#
# This program is  free software; you can redistribute  it and/or modify
# it under the  terms of the GNU General Public  License as published by
# the Free Software Foundation; either  version 2 of the License, or (at
# your option) any later version.
#
# This program  is distributed in the  hope that it will  be useful, but
# WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
# MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
# General Public License for more details.
#
# You  should have received  a copy  of the  GNU General  Public License
# along  with  this  program;  if   not,  write  to  the  Free  Software
# Foundation, Inc., 59 Temple Place  - Suite 330, Boston, MA 02111-1307,
# USA.
#
# The MQS::Storage::QDBM  file is part of the MQS project.
#
# $Id: QDBM.pm,v 1.1 2003/10/26 17:46:44 adulau Exp $

package MQS::Storage::QDBM;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use Villa;

require Exporter;
require AutoLoader;

$VERSION = '0.02';

# Create a new (or open) a queue.

sub new {
    my ( $this, $name, $path ) = @_;
    my $class = ref($this) || $this;
    my $self = {};
    bless $self, $class;
    if (
        !( $self->{villa} =
            new Villa( "$path/$name", Villa::OWRITER | Villa::OCREAT, Villa::CMPDEC )
        ) )
    {
        printf( STDERR "new failed: %s\n", $Villa::errmsg );
        return 0;
    }
    $self->{villa}->settuning( 201, 192, 1024, 512 );
    $self->{villa}->curlast();
    $self->{id}   = $self->{villa}->curkey();
    $self->{name} = $name;
    return $self;
}

sub putMessage {
    my ( $self, $message ) = @_;
    if ( !( $self->{villa}->curlast() ) ) {
        #printf( STDERR "curlast failed (new db or queue empty): %s\n", $Villa::errmsg );
        $self->{id} = 0;
	#return 1;
    }
    $self->{id}++;
    $self->{villa}->put( $self->{id}, $message, Villa::DOVER );
    return $self;
}

sub getMessage {
    my ($self) = @_;
    if ( !( $self->{villa}->curfirst() ) ) {
        #printf( STDERR "curfirst failed:%s\n", $Villa::errmsg );
	return 0;
    }
    my $curvalue = $self->{villa}->curval();
    my $curkey   = $self->{villa}->curkey();
    $self->{villa}->out($curkey);
    return $curvalue;
}

sub getLastId {
    my ($self) = @_;
    $self->{villa}->curlast();
    $self->{id} = $self->{villa}->curkey();
    return $self->{id};
}

sub close {
    my ($self) = @_;
    if ( !$self->{villa}->close() ) {
        printf( STDERR "close failed: %s\n", $Villa::errmsg );
        return 0;
    }
    return $self;
}

1;

