#!/usr/bin/perl

use RPC::XML::Client;
use Data::Dumper;
use Time::HiRes qw(gettimeofday);

my $client = new RPC::XML::Client 'https://localhost:9001/';

$x = 200;

print "Submit....";
my $beforesubmit = gettimeofday();

for my $i ( 1 .. $x) {
    my $message = "Petit test de client-mqs.pl it:" . $i;
    my $req   = RPC::XML::request->new( 'mqs.SubmitMessage', 'auth:simple:test:anotherbadsamplekey', $message, 'test', '', '-1');
    my $res   = $client->send_request($req);
    my $value = $res->value;
    #print Dumper( \$value );
}
my $elapsedsubmit = gettimeofday() - $beforesubmit;

my $beforeget = gettimeofday();

print "Get....";
for my $i ( 1 .. $x ) {
    my $req = RPC::XML::request->new( 'mqs.GetMessage', 'auth:simple:test:anotherbadsamplekey', 'test' );
    my $res = $client->send_request($req);
    my $value = $res->value;
    #print Dumper( \$value );
}

my $elapsedget = gettimeofday() - $beforeget;

print "Submit (for test bulk)....";

for my $i ( 1 .. 50) {
    my $message = "Petit test de client-mqs.pl it:" . $i;
    my $req   = RPC::XML::request->new( 'mqs.SubmitMessage', 'auth:simple:test:anotherbadsamplekey', $message, 'test', '', '-1');
    my $res   = $client->send_request($req);
    my $value = $res->value;
    #print Dumper( \$value );
}

my $beforegetbulk = gettimeofday();

for my $i ( 1 .. 1 ) {
    my $req = RPC::XML::request->new( 'mqs.GetMessageBulk', 'auth:simple:test:anotherbadsamplekey', 'test', 50);
    my $res = $client->send_request($req);
    my $value = $res->value;
    print Dumper( \$value );
}

my $elapsedgetbulk = gettimeofday() - $beforegetbulk;


print "Result :\n";
print "To submit $x messages : $elapsedsubmit ** ".$x/$elapsedsubmit." messages/second\n";
print "To get $x messages : $elapsedget ** ".$x/$elapsedget." messages/second\n";
print "To get (bulk) 50 messages : $elapsedgetbulk ** ".50/$elapsedgetbulk." messages/second\n";
 
#Clean processed message in queue
#print "Cleaning queue...";
#my $req = RPC::XML::request->new( 'mqs.DeleteMessage', 'test' );
#my $res = $client->send_request($req);
#my $value = $res->value;
#print Dumper( \$value );
#my $req = RPC::XML::request->new( 'mqs.TestEcho', 'test' );
#my $res = $client->send_request($req);
#my $value = $res->value;
#print Dumper( \$value );

